
#include "fsl_os_abstraction.h"
#include "freertos.h"
#include "task.h"
#include <stdio.h>
#include <stdlib.h>

#include "tcpip.h"

#include "cp_frame.h"

unsigned char glbOutBuf[CP_MAXSHORTBUFLEN*2];
unsigned long glbOutBufCtr;
unsigned char glbInBuf[CP_MAXSHORTBUFLEN];
unsigned long glbInBufCtr;


CP_STATUSCODE CP_EmitCharVerbatim(unsigned char p_Char)
{
    glbOutBuf[glbOutBufCtr++] = p_Char;
    return CP_STATUSCODE_SUCCESS;
}

CP_STATUSCODE CP_EmitChunkVerbatim(unsigned char *p_Chunk,unsigned long p_ChunkLen)
{
    memcpy(&glbOutBuf[glbOutBufCtr],p_Chunk,p_ChunkLen);
    glbOutBufCtr += p_ChunkLen;
    return CP_STATUSCODE_SUCCESS;
}


void SingleFrameTest(void)
{
    CP_PROCESSOR a_Processor;
    unsigned char a_RandBuf[CP_MAXSHORTBUFLEN];
    unsigned long aLoop,a_RandBuflen = rand()% CP_MAXSHORTBUFLEN;
    if (!a_RandBuflen) a_RandBuflen++;
    for(aLoop=0;aLoop<a_RandBuflen;aLoop++)
        a_RandBuf[aLoop] = rand()%(CP_FRAMESTART+1);
    glbOutBufCtr = 0;
    CP_FrameAndEmitPacket(a_RandBuf,a_RandBuflen);
    CP_InitFSM(&a_Processor);
    memset(glbInBuf,0,sizeof(glbInBuf));
    glbInBufCtr = 0;
    for(aLoop=0;aLoop<glbOutBufCtr;aLoop++)
        CP_ProcessInChar(glbOutBuf[aLoop],&a_Processor);
//    if (a_RandBuflen != (glbOutBufCtr-5))
    if ((a_RandBuflen == CP_ESCAPE) || (a_RandBuflen == CP_FRAMESTART))
//    if (glbOutBufCtr >= (a_RandBuflen + 7))
    {
        volatile unsigned long aDum = 3;
    }
    if ((a_RandBuflen != glbInBufCtr) || (memcmp(a_RandBuf,glbInBuf,glbInBufCtr)))
    {
        volatile unsigned long aDum = 2;
    }
}

// stub

CP_STATUSCODE CP_DispatchInPacketToUpperLayer(unsigned char *p_DataBuf,unsigned long p_DataLen)
{
    glbInBufCtr = p_DataLen;
    memcpy(glbInBuf,p_DataBuf,p_DataLen);
    return CP_STATUSCODE_SUCCESS;
}